<?php
if (isset($semRefrescamento)) {
	include_once '../modelo/candidatoVaga.modelo.php';
	include_once '../controlador/vaga.controlador.php';
}else {
	include_once 'modelo/candidatoVaga.modelo.php';
	include_once 'vaga.controlador.php';
} 
	
 
class ControladorCandidatoVaga 
{
 
static public function ctrAddCandidatoVaga($idVaga)
{

	if (!empty($idVaga)) 
	{ 
				$idVaga = addslashes($idVaga);
				$estado = "Candidatura Submetida";
				$dataCadastro = addslashes(date("d-m-Y H:i:s"));
				$idUsuario = addslashes($_SESSION['ID_usuario']);
				
				$dados = array("estado" => filter_var($estado,FILTER_SANITIZE_STRIPPED),
				"idVaga" => filter_var($idVaga,FILTER_SANITIZE_STRIPPED), 
				"dataCadastro" => filter_var($dataCadastro,FILTER_SANITIZE_STRIPPED), 
				"idUsuario" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED));

				$verifExistencia = ControladorCandidatoVaga::ctrVerificarSeOcandidatoJaEstaNaVaga($idVaga,$idUsuario);
				if ($verifExistencia == true) 
				{ 
					$resposta = ModeloCandidatoVaga::mdlAddCandidatoVaga($dados);

					if($resposta == "ok"){
							echo"
					<script>
					Swal.fire({
						position: 'top-end',
						icon: 'success',
						title: 'Candidatura com sucesso!',
						showConfirmButton: false,
						timer: 5000
					})
					</script>
					";	
					}else{
						echo"
						<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Não foi possivel se candidatar',
								showConfirmButton: false,
								timer: 5000
							})
						</script>";
						
					}
				}else
				{
					echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Erro: Não foi possivel candidatar Porque já esta escrito na Vaga',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
					";
				}

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}	


}
 

static public function ctrVerificarSeOcandidatoJaEstaNaVaga($idVaga,$idCandidato){

	$resposta = ModeloCandidatoVaga::mdlMostrarCandidatoNaVagaPorIdCandidatoEidVaga($idVaga,$idCandidato);
	if (empty($resposta)) { 
		return true;
	}
	else {
		return false;
	}
}

static public function ctrMostrarCandidatoNaVagaPorIdCandidatoEidVaga($idVaga,$idCandidato){

	$resposta = ModeloCandidatoVaga::mdlMostrarCandidatoNaVagaPorIdCandidatoEidVaga($idVaga,$idCandidato);
	return $resposta;
}

   
static public function ctrMostrarTodoscandidatos(){

	$resposta = ModeloCandidatoVaga::mdlMostrarTodosCandidatos();
	return $resposta;
	
}

static public function ctrContarTodosCandidatos(){

	$resposta = ModeloCandidatoVaga::mdlMostrarTodosCandidatos();
	return count($resposta);
	
}

 
static public function ctrMostrarTodosConcorrentesDaVagaEidVaga($idVaga){
	$resposta = ModeloCandidatoVaga::mdlMostrarTodosConcorrentesDaVagaEidVaga($idVaga);
	return $resposta;
}

static public function ctrMostrarTodosAlunosQuePagaramOuNaoPagaramOCertificadoPorIdVaga($idVaga,$estadoDoPagamentoCertificado){
	$resposta = ModeloCandidatoVaga::mdlMostrarTodosAlunosQuePagaramOuNaoPagaramOCertificadoPorIdVaga($idVaga,$estadoDoPagamentoCertificado);
	return $resposta;
}  

static public function ctrContarTodosAlunosQuePagaramOuNaoPagaramOCertificadoPorIdVaga($idVaga,$estadoDoPagamentoCertificado){
	$resposta = ModeloCandidatoVaga::mdlMostrarTodosAlunosQuePagaramOuNaoPagaramOCertificadoPorIdVaga($idVaga,$estadoDoPagamentoCertificado); 
	return count($resposta);
}

static public function ctrMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	return $resposta;
}

static public function ctrMostrarIdDaRespostaPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	if (empty($resposta[count($resposta)-1]["idResposta"]) || $resposta[count($resposta)-1]["idResposta"] == "") {
		return 0;
	}else {
		return ControladorResposta::ctrMostrarOIdDaPerguntaDestaRespostaPorIdResposta($resposta[count($resposta)-1]["idResposta"]);
	}
	
}

static public function ctrMostrarPontosDocandidatoPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$postos = 0;
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	foreach ($resposta as $key => $value) {
		$dadoResposta = ControladorResposta::ctrMostrarRespostaPorIdResposta($value["idResposta"]);
		$postos = $postos + $dadoResposta[0]["pontuacao"];
	}
	return $postos;
	
}

static public function ctrMostrarTodosCursoQueOCandidatoFezDeUmProfessorrOuOrganizacao($idInstrutorOuIdOrganizacao,$idCandidato){
	$resultado = array();
	$MeusCurso = ControladorVaga::ctrMostrarMinhasCursosDaOrganizacaoPorIdOrganizacao($idInstrutorOuIdOrganizacao);
	foreach ($MeusCurso as $key => $value) {

		$todoEstudantes = ControladorCandidatoVaga::ctrMostrarTodosConcorrentesDaVagaEidVaga($value["idVaga"]);
		foreach ($todoEstudantes as $key => $value1) {
			$estudantes = ControladorCandidatoVaga::ctrMostrarCandidatoNaVagaPorIdCandidatoEidVaga($value["idVaga"],$value1["idCandidato"]);
			if (!empty($estudantes)) {
				$resultado[] = $value["idVaga"];
			}
		}	
	}
	return $resultado;
	
}

static public function ctrMostrarTodosEstudantesDeTodosOsCursoDeUmProfessorOuOrganizacao($idInstrutorOuIdOrganizacao){
	$resultado = array();
	$MeusCurso = ControladorVaga::ctrMostrarMinhasCursosDaOrganizacaoPorIdOrganizacao($idInstrutorOuIdOrganizacao);
	foreach ($MeusCurso as $key => $value) {

		$todoEstudantes = ControladorCandidatoVaga::ctrMostrarTodosConcorrentesDaVagaEidVaga($value["idVaga"]);
			
	}
	return $todoEstudantes;
	
}

static public function ctrMostrarOrdemDaPerguntaActual($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	if (empty($resposta[count($resposta)-1]["idResposta"]) || $resposta[count($resposta)-1]["idResposta"] == "") {
		return 0;
	}else {
		return ControladorPergunta::ctrMostrarOrdemDaPergunta(ControladorResposta::ctrMostrarOIdDaPerguntaDestaRespostaPorIdResposta($resposta[count($resposta)-1]["idResposta"]));
	}
	
}

 


static public function ctrMostrarTodosVagasDoConcorrentesPorIdCandidato($idCandidato){

		$resposta = ModeloCandidatoVaga:: mdlMostrarTodosVagasDoConcorrentesPorIdCandidato($idCandidato);

		return $resposta;

	}  

	static public function ctrActualizarEstadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $estado){

		$resposta = ModeloCandidatoVaga::mdlActualizarEstadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $estado);

		return $resposta;

	}

	static public function ctrActualizarValorPagoPeloCertificadoEDoEstadoDoPagamentoDoCertificadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $valorPagoCertificado,$estadoDoPagamentoCertificado){

		$resposta = ModeloCandidatoVaga::mdlActualizarValorPagoPeloCertificadoEDoEstadoDoPagamentoDoCertificadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $valorPagoCertificado,$estadoDoPagamentoCertificado);

		return $resposta;

	}
 
	static public function ctrActualizarDadosUsuarioprofessors($nome, $bi_nif, $nivelDeAcesso, $id){  

		$resposta = ModeloCandidatoVaga::mdlActualizarDadosUsuarioprofessors(addslashes($nome), addslashes($bi_nif), addslashes($nivelDeAcesso),addslashes($id));

		return $resposta;

	}

	static public function ctrActualizarImagemPerfilUsuario($imagem,$id){

		$resposta = ModeloUsuario::mdlActualizarImagemPerfilUsuario($imagem,addslashes($id));

		return $resposta;

	}

	static public function ctrActualizarCodigoParaReporSenha($idUsuario, $codigo){

		$resposta = ModeloUsuario::mdlActualizarCodigoParaReporSenha($idUsuario, $codigo);
		return $resposta;

	}
 
	static public function ctrActualizarSenhaUsuario($senhaAntiga,$id, $senha){

		$resposta = ModeloUsuario::mdlActualizarSenhaUsuario(addslashes($senhaAntiga),addslashes($id), md5(addslashes($senha)));
		return $resposta;

	}

	static public function ctrActualizarReporSenhaUsuario($senha,$id,$codigoParaReporSenha){

		$resposta = ModeloUsuario::mdlActualizarReporSenhaUsuario(md5(addslashes($senha)),$id,$codigoParaReporSenha);
		return $resposta;

	}

	static public function ctrDeletarUsuario($id){

		$resposta = ModeloUsuario::mdlDeletarUsuario(addslashes($id));
		return $resposta;

	}

}

?>